create or replace procedure tbicds.PRC_UTL_BACKUP_FX_AUDIT
AUTHID CURRENT_USER
is
   v_vSql                               varchar2(4000);
   v_nHandle                            number;
   v_vOraDirectoryName                  varchar2(30) := 'DIR_FX_AUDIT_BACKUP';
   v_vWinBackupDirectory                varchar2(256) := getParameterValue('FX_AUDIT_BACKUP_DIR');
   v_vFileName                          varchar2(128);
   v_vNameList                          varchar2(128) := 'FX_AUDIT';
   v_nRetentionDays                     number := getParameterValue('FX_AUDIT_RETENTION_DAYS');
begin
   v_vFileName := 'FX_AUDIT_'||to_char(sysdate,'YYYYMMDD')||'.DMP';
   prc_utl_execute_sql ('create or replace directory '||v_vOraDirectoryName||' as '''||v_vWinBackupDirectory||'''');
   
   v_nHandle := dbms_datapump.open(
                   operation => 'EXPORT',
                   job_mode  => 'TABLE');
   
   dbms_datapump.add_file(
      handle    => v_nHandle,
      filename  => v_vFileName,
      directory => v_vOraDirectoryName);
   
   dbms_datapump.add_file(
      handle    => v_nHandle,
      filename  => v_vFileName||'.LOG',
      directory => v_vOraDirectoryName,
      filetype  => DBMS_DATAPUMP.KU$_FILE_TYPE_LOG_FILE);
   
   dbms_datapump.metadata_filter(
      handle => v_nHandle,
      name   => 'NAME_LIST',
      value  => v_vNameList);
   
   dbms_datapump.start_job(v_nHandle);
   
   dbms_datapump.detach(v_nHandle);

   prc_utl_execute_sql ('drop directory '||v_vOraDirectoryName);
   
   -- delete older records
   v_vSql := 'delete from fx_audit where audit_date < :P0';
   execute immediate v_vSql using trim(sysdate - v_nRetentionDays);
   commit;
   
exception
   when others
   then
      null;
end;
/

